/*---------------------------------------------------------------------------*\

	FILE....: cidgtest.cpp
	TYPE....: C Program
	AUTHOR..: Peter Wintulich
	DATE....: 12/11/02

	Test program for OpenSwitch12 Caller ID transmit
	

	Compile: gcc cidgtest.cpp cidg.cpp -o cidgtest -lvpb -lm -pthread -Wall

\---------------------------------------------------------------------------*/
	
#include <assert.h>
#include <time.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../src/vpbapi.h"
#include "kbhit.h"


/*-----------------------------------------------------------------------\
 *
 *
 *
 *
\-----------------------------------------------------------------------*/
int main(int argc, char *argv[]) 
{
	int	h;			// vpb channel handle
	int     ch_num;			// channel #
	short   buf[VPB_CID_MAX_BUF];	// wave holding buffer
	int	buff_count=0;		// active word count in buf
	int	x,n;
	char	VPB_DLP[VPB_CID_MAX_DLP];	// Datalink Layer 
	int 	pg,lamp,hamp;	
	char	*file=NULL;		// pointer to output filename
    	void 	*ws;			// file handle
	char	number[50];
	char	txtmessage[50];

	vpb_seterrormode(VPB_DEVELOPMENT);
	
	if (argc == 1) {
	    printf("Usage: ./cidgtest file.wav Ch[1..] P[gain]\n");
	    printf("Usage: ./cidgtest 1 Ch[1..] [P[gain]] [F[fileout.wav]]\n");
	    printf("                  [m[message]] [n[number]]\n");
		exit(0);
	}
	
	strcpy(number,"8451 5108");
	strcpy(txtmessage,"Voicetronix");
	
	ch_num = atoi(argv[2]);
	h = vpb_open(1, ch_num);

	// Collect optional parameters
	if (argc >3)
	{	
  	    for(x=3; x<argc ; x++)
	       switch(*(argv[x]))
	       {
		   case 'h':
		   case 'H': 	 
	       		hamp=atoi(argv[x]+1);	       
	       		printf("High F amp=%d\n",hamp);	       
			printf("not implimented\n");
			break;	
		   case 'l':
		   case 'L': 	 
	       		lamp=atoi(argv[x]+1);	       
	       		printf("Low F amp=%d\n",lamp);
	 		printf("not inplemented\n");		
			break;
		   case 'p':
		   case 'P': 	 
	       		pg=atoi(argv[x]+1);	       
	       		printf("Play Gain=%d\n",pg);	       
			vpb_play_set_gain(h,pg);
			break;
		   case 'f':
		   case 'F': 	 
	       		file=(argv[x])+1;	       
	       		printf("Wave File=%s\n",file);	       
			break;
		   case 'm':
		   case 'M': 	 
	       		strcpy(txtmessage,(argv[x])+1);	       
	       		printf("Message=%s\n",txtmessage);	       
			break;
		   case 'n':
		   case 'N': 	 
	       		strcpy(number,(argv[x])+1);	       
	       		printf("Number=%s\n",number);	       
			break;
	       }	
		
	}
	
	//----------------Message creation-----------------------------	
	VPB_CID	message;			// create VPB_CID structure
	vpb_cid_set(&message,VPB_CID_EMPTY,NULL);	// Initalize fields

	vpb_cid_set(&message,VPB_CID_CALLING_LINE_DN,(void *)number);
	vpb_cid_set(&message,VPB_CID_CALLER_NAME,(void *)txtmessage);
//	vpb_cid_set(&message,VPB_CID_CALLING_LINE_DN,(void *)"84155108");
//	vpb_cid_set(&message,VPB_CID_CALLER_NAME,(void *)"Voicetronix");
	n= vpb_cid_compose_dlp(&message, VPB_DLP);

	vpb_cid_compose_wav(VPB_DLP, n, buf, &buff_count);

	printf("buff_count = %d \n",buff_count);

	x=0;

	//	Print hex dump of DLP to screen
	//	for(x=0;x<buff_count;x++)
	//	printf("%x ,%d \n",x,buf[x]);
	
	//-----------Write composed wave to file--------------------
			
    	if(file!=NULL) 
    	{	    
		vpb_wave_open_write(&ws, file, VPB_LINEAR);
		vpb_wave_write(ws,(char*)buf,buff_count*2);
		vpb_wave_close_write(ws);
    	}
	//-----------Send First ring--------------------------------	
	vpb_sleep(1000);		// wait for card to initalize
	vpb_user_ring_station_sync(h,VPB_RING_STATION_ON);
	vpb_sleep(500);
	vpb_user_ring_station_sync(h,VPB_RING_STATION_OFF);
	vpb_sleep(600);
	//-----------Play file or buffer---------------------------- 
	if(*(argv[1]) == '1')
    	{	    
		printf("Sending composed CID\n");
	        vpb_play_buf_start(h, VPB_LINEAR);
	        vpb_play_buf_sync(h, (char*)buf, buff_count*2);
		vpb_sleep(50);
		vpb_play_buf_finish(h);
    	}	
    	else
    	{
		printf("Sending FILE\n");    
		vpb_play_file_sync(h,argv[1]);
    	}	
	//-----------Send second ring------------------------------
	vpb_sleep(400);
	vpb_user_ring_station_sync(h,VPB_RING_STATION_ON);
	vpb_sleep(800);
	vpb_user_ring_station_sync(h,VPB_RING_STATION_OFF);
	
	vpb_close(h);	

	return 0;
}



